set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 1


**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	
	collapse (mean) D1_lnlaborshare D1_lnEMP D1_LP1_EMP weight*, by(sector_short code sectorgroup) /*mean across country-years*/

save $path_temp\temp_F1, replace

	
**2. Figure 1, upper panel 
use $path_temp\temp_F1, clear

	*Regression equivalent
	reg D1_lnEMP D1_LP1_EMP [w=weight]
	eststo col1
	esttab col1,  b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 

	gen slabel=sector_short if code=="51"|code=="C"|code=="F"|code=="15t16"|code=="23"|code=="M"|code=="26"|code=="64"|code=="50"|code=="H"|code=="J"|code=="N"|code=="E"|code=="O"|code=="71t74"|code=="70"|code=="30t33"|code=="24"|code=="25"|code=="17t19"|code=="20"|code=="34t35"
	gen pos=12
	replace pos=2 if code=="51"
	replace pos=3 if code=="N" | code=="24" | code=="34t35"  | code=="25" | code=="51"
	replace pos=6 if code=="34t35" | code=="O" | code=="H" | code=="20" |code=="15t16" | code=="26"
	replace pos=9 if code=="F" | code=="H" |  code=="O" 
		
	twoway 	(scatter D1_lnEMP D1_LP1_EMP if sectorgroup==1, msymbol(Oh) mcolor(navy) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnEMP D1_LP1_EMP if sectorgroup==2, msymbol(d)  mcolor(maroon) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnEMP D1_LP1_EMP if sectorgroup==3, msymbol(T)  mcolor(forest_green) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnEMP D1_LP1_EMP if sectorgroup==4, msymbol(+)  mcolor(dkorange) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnEMP D1_LP1_EMP if sectorgroup==5, msymbol(O)  mcolor(teal) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8) ///
			 xlabel(-2.5(.5)5) ///
			legend(order(1 "Mining, util's & construction" 2 "Manufacturing" 3 "Education & health" 4 "Low-tech svcs" 5 "High-tech svcs" 6 "Weighted linear fit")) legend(rows(2)) legend(span) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///	
			ytitle("Average annual employment change" "(log points)") xtitle("Average annual TFP growth (log points)") ///
			note("Unweighted average across country-years; linear fit is weighted by industries' employment shares," "slope coefficient is -0.949 (standard error 0.181), R2=0.515.", span)) ///
			(lfit D1_lnEMP D1_LP1_EMP [w=weight], lcolor(black))
				
graph export "$path_out\Fig1A.eps", as(eps) replace		


**3. Figure 1, bottom panel 
use $path_temp\temp_F1, clear

	*Regression equivalent
	reg D1_lnlaborshare D1_LP1_EMP [w=weight_VA]
	eststo col1
	esttab col1,  b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 

	gen slabel=sector_short if code=="15t16"|code=="60t63"||code=="F"|code=="C"|code=="23"|code=="29"|code=="50"|code=="64"|code=="M"|code=="H"|code=="E"|code=="O"|code=="71t74"|code=="70"|code=="30t33"|code=="24"|code=="25"|code=="17t19"|code=="20"|code=="34t35"
	gen pos=12
	replace pos=1 if code=="29"
	replace pos=3 if code=="50"|code=="17t19"
	replace pos=6 if code=="34t35" | code=="O" | code=="F" | code=="60t63"
	replace pos=9 if code=="H" |  code=="O" | code=="20"

	twoway 	(scatter D1_lnlaborshare D1_LP1_EMP if sectorgroup==1, msymbol(Oh) mcolor(navy) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnlaborshare D1_LP1_EMP if sectorgroup==2, msymbol(d)  mcolor(maroon) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnlaborshare D1_LP1_EMP if sectorgroup==3, msymbol(T)  mcolor(forest_green) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnlaborshare D1_LP1_EMP if sectorgroup==4, msymbol(+)  mcolor(dkorange) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter D1_lnlaborshare D1_LP1_EMP if sectorgroup==5, msymbol(O)  mcolor(teal) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8) ///
			 xlabel(-2.5(.5)5) ///
			legend(order(1 "Mining, util's & construction" 2 "Manufacturing" 3 "Education & health" 4 "Low-tech svcs" 5 "High-tech svcs" 6 "Weighted linear fit")) legend(rows(2)) legend(span) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///	
			ytitle("Average annual labor share change" "(log points)") xtitle("Average annual TFP growth (log points)") ///
			note("Unweighted average across country-years; linear fit is weighted by industries' value-added shares," "slope coefficient is -0.143 (standard error 0.050), R2=0.238.", span)) ///
			(lfit D1_lnlaborshare D1_LP1_EMP [w=weight_VA], lcolor(black))
							
graph export "$path_out\Fig1B.eps", as(eps) replace					

	
*Erase temporary dataset	
cap erase $path_temp\temp_F1.dta
